//        memo02.cpp
#define STRICT
#include <windows.h>
#include <stdio.h>
#include <windowsx.h> // }NĝŕKv
#include "resource.h" //\[XGW^gp
#define ID_EDIT 100 // GWbgRg[ID

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
BOOL InitApp(HINSTANCE);
BOOL InitInstance(HINSTANCE, int);
int OpenMyFile(HWND);
int WriteMyFile(HWND);
int CompileMyFile(HWND);
int OverWriteMyFile(HWND);
int MakeNewFile(HWND);
int FimdMyWord(HWND);
int SearchMyWord(HWND, /*UINT, WPARAM,*/ LPARAM);

char szClassName[] = "memo02";        //EBhENX
char szFileName[256]; // I[vt@CipXtj
char szFile[64] = ""; // t@C
HINSTANCE hInst; // CX^Xnh
HWND hEdit; // GWbgEBhẼnh
char szStr[1024 * 64];
char szFindWhat[256];
UINT uFind;
FINDREPLACE fr;
HINSTANCE _Instance;

int WINAPI WinMain(HINSTANCE hCurInst, HINSTANCE hPrevInst,
                   LPSTR lpsCmdLine, int nCmdShow)
{
    MSG msg;
    
    if (!hPrevInst) {
        if (!InitApp(hCurInst))
            return FALSE;
    }
    if (!InitInstance(hCurInst, nCmdShow)) {
        return FALSE;
    }
    uFind = RegisterWindowMessage(FINDMSGSTRING);

    while (GetMessage(&msg, NULL, 0, 0)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return msg.wParam;
}

/*************************************************************************/
/*                   JgfBNg֐                        */
/*	OUT	:	dwd݂̑Ăꏊ܂ł̃pXԂ					 */
/*************************************************************************/
char* SYS_GetDir(void)
{
	static int i;
	static char Buffer[256];
	
	// JgfBNgB̎擾
	GetModuleFileName(_Instance, Buffer, 256);

	for (i = strlen(Buffer); Buffer[i] != '\\'; i--) Buffer[i] = NULL;
	
	return Buffer;
}

//EBhEENX̓o^

BOOL InitApp(HINSTANCE hInst)
{
    WNDCLASS wc;
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WndProc;    //vV[W
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;        //CX^X
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName = "MYMENU";    //j[
    wc.lpszClassName = (LPCSTR)szClassName;

	_Instance=hInst;
    return (RegisterClass(&wc));
}



//EBhE̐

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
    HWND hWnd;
    hInst = hInstance; // CX^XnhO[oϐɃRs[
    hWnd = CreateWindow(szClassName,
            "Lł킩GW^",    //^Cgo[ɂ̖O\܂
            WS_OVERLAPPEDWINDOW,    //EBhE̎
            CW_USEDEFAULT,    //wW
            CW_USEDEFAULT,    //xW
            CW_USEDEFAULT,    //
            CW_USEDEFAULT,    //
            NULL,        //eEBhẼnhAeƂNULL
            NULL,        //j[nhANXj[gƂNULL
            hInstance,    //CX^Xnh
            NULL);
    if (!hWnd)
        return FALSE;
    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);
    return TRUE;
}


//EBhEvV[W

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
    int id;
    RECT rc;

    switch (msg) {
        case WM_CREATE:
            GetClientRect(hWnd, &rc);
            hEdit = CreateWindow(
                "EDIT",
                NULL,
                WS_CHILD | WS_VISIBLE | 
                ES_WANTRETURN | ES_MULTILINE | ES_AUTOVSCROLL | WS_VSCROLL |
                ES_AUTOHSCROLL | WS_HSCROLL | ES_NOHIDESEL,
                0, 0,
                rc.right, rc.bottom,
                hWnd,
                (HMENU)ID_EDIT,
                hInst,
                NULL);
            SendMessage(hEdit, EM_SETLIMITTEXT, (WPARAM)1024*64, 0);
            break;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDM_END:
                    SendMessage(hWnd, WM_CLOSE, 0, 0);
                    break;
                case IDM_OPEN:
                    OpenMyFile(hWnd);
                    break;
                case IDM_WRITE:
                    WriteMyFile(hWnd);
                    break;
                case IDM_UWAGAKI:
                    OverWriteMyFile(hWnd);
                    break;
                case IDM_COMPILE:
                    CompileMyFile(hWnd);
                    break;
                case IDM_NEW:
                    MakeNewFile(hWnd);
                    break;
                case IDM_FIND:
                    FimdMyWord(hWnd);
                    break;
            }
            break;
        case WM_SIZE:
            GetClientRect(hWnd, &rc);
            MoveWindow(hEdit, rc.left, rc.top,
                rc.right, rc.bottom,
                TRUE);
            break;
        case WM_CLOSE:
            if (SendMessage(hEdit, EM_GETMODIFY, 0, 0) == TRUE) {
                id = MessageBox(hWnd,
                "ύXĂ܂Bۑ܂H",
                "",
                MB_YESNO | MB_ICONQUESTION);
                if (id == IDYES)
                    WriteMyFile(hWnd);
            }
            DestroyWindow(hWnd);
            break;
        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            if (msg == uFind) {
                SearchMyWord(hWnd, lp);
                break;
            } else {
                return (DefWindowProc(hWnd, msg, wp, lp));
            }
    }
    return 0L;
}



int OpenMyFile(HWND hWnd)
{
    int id;
    DWORD dwSize = 0L;
    OPENFILENAME ofn;
    HANDLE hFile;
    DWORD dwAccBytes;
    char szTitle[64], *szTitle_org = "Lł킩GW^[%s]";

    if(SendMessage(hEdit, EM_GETMODIFY, 0, 0) == TRUE) {
        id = MessageBox(hWnd,
                "ύXĂ܂Bۑ܂H",
                "ӁI",
                MB_OKCANCEL);
        if (id == IDOK)
            WriteMyFile(hWnd);
    }

    memset(&ofn, 0, sizeof(OPENFILENAME));
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = hWnd;
	ofn.lpstrInitialDir=SYS_GetDir();
    ofn.lpstrFilter = "ns text(*.nk)\0*.nk\0All files(*.*)\0*.*\0\0";
    ofn.lpstrFile = szFileName;
    ofn.lpstrFileTitle = szFile;
    ofn.nMaxFile = MAX_PATH;
    ofn.nMaxFileTitle = sizeof(szFile);
    ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
    ofn.lpstrDefExt = "nk";
    ofn.lpstrTitle = "t@CI[vI";

    if(GetOpenFileName(&ofn) == 0)
        return -1;
    hFile = CreateFile(szFileName, GENERIC_READ, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
    dwSize = GetFileSize(hFile, NULL);
    if (dwSize >= 1024*64) {
        MessageBox(hWnd, "t@CTCY傫܂", "Too Big File!", MB_OK);
        CloseHandle(hFile);
        dwSize = 0L;
        return -1;
    }
    SetFilePointer(hFile, 0, 0, FILE_BEGIN);

    ReadFile(hFile, szStr, dwSize, &dwAccBytes, NULL);
    szStr[dwAccBytes] = '\0';
    Edit_SetText(hEdit, szStr);
    wsprintf(szTitle, szTitle_org, szFile);
    SetWindowText(hWnd, szTitle);
    CloseHandle(hFile);
    return 0;
}


int WriteMyFile(HWND hWnd)
{
    OPENFILENAME ofn;
    HANDLE hFile;
    DWORD dwAccBytes;
    char szTitle[64], *szTitle_org = "Lł킩GW^[%s]";
    int nLen;
    
    memset(szStr, '\0', sizeof(szStr));
    nLen = GetWindowTextLength(hEdit);
    GetWindowText(hEdit, szStr, nLen + 1);
    
    memset(&ofn, 0, sizeof(OPENFILENAME));
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = hWnd;
	ofn.lpstrInitialDir=SYS_GetDir();
    ofn.lpstrFilter = "text(*.txt)\0*.txt\0All files(*.*)\0*.*\0\0";
    ofn.lpstrFile = szFileName;
    ofn.lpstrFileTitle = szFile;
    ofn.nFilterIndex = 1;
    ofn.nMaxFile = sizeof(szFileName);
    ofn.nMaxFileTitle = sizeof(szFile);
    ofn.Flags = OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
    ofn.lpstrDefExt = "txt";
    ofn.lpstrTitle = "OtĕۑI";

    if(!GetSaveFileName(&ofn))
        return -1;
    hFile = CreateFile(szFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
    WriteFile(hFile, szStr, strlen(szStr) + 1, &dwAccBytes, NULL);
    wsprintf(szTitle, szTitle_org, szFile);
    SetWindowText(hWnd, szTitle);
    if(CloseHandle(hFile) == 0)
        MessageBox(hWnd, "Error CloseHandle", "Error", MB_OK);
    SendMessage(hEdit, EM_SETMODIFY, FALSE, 0);
    return 0;
}


typedef long NINT;
int CompileMyFile(HWND hWnd)
{
    OPENFILENAME ofn;
    HANDLE hFile;
    DWORD dwAccBytes;
    char szTitle[64], *szTitle_org = "Lł킩GW^[%s]";
    int nLen;
    
    memset(szStr, '\0', sizeof(szStr));
    nLen = GetWindowTextLength(hEdit);
    GetWindowText(hEdit, szStr, nLen + 1);
    
    memset(&ofn, 0, sizeof(OPENFILENAME));
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = hWnd;
	ofn.lpstrInitialDir=SYS_GetDir();
    ofn.lpstrFilter = "ns script(*.sc)\0*.sc\0All files(*.*)\0*.*\0\0";
    ofn.lpstrFile = szFileName;
    ofn.lpstrFileTitle = szFile;
    ofn.nFilterIndex = 1;
    ofn.nMaxFile = sizeof(szFileName);
    ofn.nMaxFileTitle = sizeof(szFile);
    ofn.Flags = OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
    ofn.lpstrDefExt = "sc";
    ofn.lpstrTitle = "OtĕۑI";

    if(!GetSaveFileName(&ofn))
        return -1;
    hFile = CreateFile(szFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);


	//***************************************
	NINT iAdr=0;
	char* cp= szStr;
	while(*cp){
		if(*cp >= 'a' && *cp <= 'z'){//ߎ
				WriteFile(hFile, cp, 1, &dwAccBytes, NULL);//cp
				
				cp++;
				int t;
				sscanf(cp,"%d;",&t);
				WriteFile(hFile, (BYTE*)&t, sizeof(BYTE), &dwAccBytes, NULL);//fwrite(&t,sizeof(char),1,fp);

				sprintf(cp,"%d",t),cp+=strlen(cp);//'%d;'
		}
		else{
			switch(*cp)
			{
			case '$':// "$//"
			{
				cp++;

				char* sc=cp;
				NINT nCnt=0;
				while(! ((*sc=='/') && ((*(sc+1))=='/')) ){
					sc++;nCnt++;
				}
				
				char ts[16];
				sprintf(ts,"%ld!",nCnt);
				WriteFile(hFile,ts,strlen(ts), &dwAccBytes, NULL);//fprintf(fp,"%ld!",nCnt);

				WriteFile(hFile, cp, nCnt, &dwAccBytes, NULL);//fwrite(cp,sizeof(char),nCnt,fp);

				cp=sc+1;
			}
			break;
			case '\n':case '\r':break;//MessageBox(hWnd,cp,NULL,NULL);
			case '*'://Rg
			{
				cp=strchr(cp,'\n');
			}
			break;
			default:WriteFile(hFile, cp, 1, &dwAccBytes, NULL);//fputc(*cp,fp);
			}
		}
		cp++;
	}

//	char ed='\0';WriteFile(hFile, &ed, 1, &dwAccBytes, NULL);

    wsprintf(szTitle, szTitle_org, szFile);
    SetWindowText(hWnd, szTitle);
    if(!CloseHandle(hFile))
        MessageBox(hWnd, "Error CloseHandle", "Error", MB_OK);
    SendMessage(hEdit, EM_SETMODIFY, FALSE, 0);
    return 0;
}


int OverWriteMyFile(HWND hWnd)
{
    HANDLE hFile;
    DWORD dwAccBytes;
    int nLen;

    memset(szStr, '\0', sizeof(szStr));
    nLen = GetWindowTextLength(hEdit);
    GetWindowText(hEdit, szStr, nLen + 1);

    hFile = CreateFile(szFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
    WriteFile(hFile, szStr, strlen(szStr) + 1, &dwAccBytes, NULL);
    SendMessage(hEdit, EM_SETMODIFY, FALSE, 0);
    if (CloseHandle(hFile) == 0) {
        MessageBox(hWnd, "Error CloseHandle", "Error", MB_OK);
        return -1;
    }
    return 0;
}


int MakeNewFile(HWND hWnd)
{
    int id;
    char szTitle[64], *szTitle_org = "Lł킩GW^[%s]";

    if (SendMessage(hEdit, EM_GETMODIFY, 0, 0) == TRUE) {
        id = MessageBox(
            hWnd,
            "XVĂ܂Bۑ܂H",
            "",
            MB_YESNO | MB_ICONQUESTION);
        if (id == IDYES)
            WriteMyFile(hWnd);
    }
    wsprintf(szTitle, szTitle_org, "");
    SetWindowText(hWnd, szTitle);
    strcpy(szStr, "");
    Edit_SetText(hEdit, szStr);
    return 0;
}


int FimdMyWord(HWND hWnd)
{
    HWND hFind;
    memset(&fr, 0, sizeof(FINDREPLACE));
    fr.lStructSize = sizeof(FINDREPLACE);
    fr.hwndOwner = hWnd;
    fr.lpstrFindWhat = szFindWhat;
    fr.wFindWhatLen = 256;
    fr.Flags = FR_HIDEWHOLEWORD |
        FR_HIDEUPDOWN | FR_HIDEMATCHCASE;
    hFind = FindText(&fr);
    return 0;
}


int SearchMyWord(HWND hWnd, LPARAM lp)
{
    int id;
    LPFINDREPLACE lpfr;
    static DWORD dwPos = 0;
    static DWORD dwCurPos;
    LPSTR lpFindPoint;
    static char buf[1024*64-1]; 
    
START:
    lpfr = (LPFINDREPLACE)lp;
    if (lpfr->Flags & FR_FINDNEXT) {
        dwCurPos = SendMessage(hEdit, EM_GETSEL, 0, 0);
        if (LOWORD(dwCurPos) == dwPos && dwPos > 0)
            dwPos++;
        else
            dwPos = LOWORD(dwCurPos);
        SendMessage(hEdit, WM_GETTEXT, sizeof(buf), (LPARAM)buf);
        lpFindPoint = strstr(&buf[LOWORD(dwPos)], lpfr->lpstrFindWhat);
        if (lpFindPoint) {
            dwPos = lpFindPoint - buf;
            SendMessage(hEdit, EM_SETSEL, dwPos, strlen(lpfr->lpstrFindWhat)+dwPos);
            SendMessage(hEdit, EM_SCROLLCARET, 0, 0);
        } else {
            id = MessageBox(hWnd,
                "t@C̍Ō܂Ō܂B擪T܂H",
                "Find",
                MB_YESNO);
            if (id == IDYES) {
                dwPos = 0;
                dwCurPos = 0;
                SendMessage(hEdit, EM_SETSEL, 0, 0);
                goto START;
            }
        }
    }
    return 0;
}

